//Dustin Soodak

//behavior 037: accel xy and gyro, can compare float and integer calculations
//
//imitating calculations on AccelXYGData tab of Moody1 spreadsheet
//there is "foating point version" and "int version"
//
//#define FLOAT_VER
#define INT_VER
//
#include "MiscHardware.h"
#include "Navigation.h"
#include <math.h>
void setup(){
  HardwareBegin();
  SwitchButtonToPixels();
  PlayChirp(1000, 50);SetPixelRGB(5,0,0,50);SetPixelRGB(6,0,0,50);RefreshPixels();
  delay(100);
  PlayChirp(1000, 0);SetPixelRGB(5,0,0,0);SetPixelRGB(6,0,0,0);RefreshPixels();  
  
}
int accelx,accely,accelz,dir;
int i;
int accelraw[3];
int accelrawtemp[3];
int accel[3];
int gyroraw[3];
int gyro[3];
#ifdef FLOAT_VER
float gyropos=0,accelxvel=0,accelxpos=0,accelyvel=0,accelypos=0;
float Theta,CosTheta,SinTheta;
#endif
#ifdef INT_VER
int32_t gyropos=0,accelxvel=0,accelyvel=0,accelxpos=0,accelypos=0;
int degr;
int CosDegr,SinDegr;
//float Theta;
//int32_t CosTheta,SinTheta;
const int SinTable[]={0,286,572,857,1143,1428,1713,1997,2280,2563,2845,3126,3406,3686,3964,4240,4516,4790,5063,5334,5604,5872,6138,6402,6664,6924,7182,7438,7692,7943,8192,8438,8682,8923,9162,9397,9630,9860,10087,10311,10531,10749,10963,11174,11381,11585,11786,11982,12176,12365,12551,12733,12911,13085,13255,13421,13583,13741,13894,14044,14189,14330,14466,14598,14726,14849,14968,15082,15191,15296,15396,15491,15582,15668,15749,15826,15897,15964,16026,16083,16135,16182,16225,16262,16294,16322,16344,16362,16374,16382,16384};
int SinFunction(int degr){
  int sign=1;
  if(degr<0){
    sign=-1;
    degr=-degr;
  }
  if(degr>360)
    degr%=360;
  if(degr<=90)
    return sign*SinTable[degr];
  else if(degr<=180)
    return sign*SinTable[180-degr];
  else if(degr<=270)
    return -sign*SinTable[degr-180];
  else
    return -sign*SinTable[270-degr];
}
int CosFunction(int degr){
   if(degr<0)
     degr=-degr;
   if(degr>360)
     degr%=360;
   if(degr<=90)
     return SinTable[90-degr];
   else if(degr<=180)
     return -SinTable[degr-90];
   else if(degr<=270)
     return -SinTable[270-degr];
   else
     return SinTable[360-degr];
}

#endif
int32_t rawaccelsquared,accelsquared;
//
#define DAT_SIZE (110)//150
int gyroZ[DAT_SIZE];
int accelX[DAT_SIZE];
int accelY[DAT_SIZE];
int datpos=0;
char motorson=0;
int32_t accelXzero=0,accelYzero,gyrozero=0;
//
char ch;
String NumString="";
int motoroffset=0;
int leftmotor=-200,rightmotor=-200;
char mode=0;
char gyrobufsize;
void loop(){
  SwitchPixelsToButton();    
  SwitchMotorsToSerial();
  Serial.println("Enter motors, press button to continue");
  Serial.print("motors: ");Serial.print(leftmotor,DEC);Serial.print(" ");Serial.println(rightmotor,DEC);
  Serial.println("enter left motor");
  mode=0;//in this case, used for motor selection
  while(!ButtonPressed()){
    if(Serial.available() > 0){
      ch = Serial.read();    
      if (isDigit(ch) || ch=='-'){        
        NumString += (char)ch;
      }
      if(ch=='\n'){
        if(mode==0){
          leftmotor=NumString.toInt();//-25 works well for robot 1
          Serial.print("motors: ");Serial.print(leftmotor,DEC);Serial.print(" ");Serial.println(rightmotor,DEC);
          Serial.println("enter right motor");
          mode=1;
        }  
        else if(mode==1){
          rightmotor=NumString.toInt();//-25 works well for robot 1
          Serial.print("motors: ");Serial.print(leftmotor,DEC);Serial.print(" ");Serial.println(rightmotor,DEC);
          Serial.println("enter left motor");
          mode=0;
        }
        NumString="";
      }
    }//end if(Serial.available() > 0)
  }
  Serial.println("starting");
  delay(1000);
  NavigationBegin();  
  RestartTimer();
  SwitchButtonToPixels();
  SetPixelRGB(5,50,0,0);SetPixelRGB(6,50,0,0);RefreshPixels();
  datpos=0;
  accelXzero=0;
  accelYzero=0;
  gyrozero=0;
  motorson=0; 
  gyropos=0;
  accelxvel=0;
  accelxpos=0;
  accelyvel=0;
  accelypos=0;
  mode=0;//in this case, used for data collection sequence
  while(1){
    //SimpleNavigation();   
    gyrobufsize=GyroBufferSize();
    if(gyrobufsize>0){//gyro is slower so this should also mean there is some accel data      
      GyroGetAxes(gyroraw);//380 hz 
      AccelGetAxes(accelraw);//400 hz
      if(AccelBufferSize()>gyrobufsize){//to keep buffers in sync
         AccelGetAxes(accelrawtemp);
         for(i=0;i<3;i++){
            accelraw[i]=(accelraw[i]+accelrawtemp[i])/2;
         }
      }
      
      switch(mode){
      case 0://find zeroes
        if(datpos<(DAT_SIZE)){
          accelXzero+=accelraw[0];
          accelYzero+=accelraw[1];
          gyrozero+=gyroraw[2];
          datpos++;
        }
        else{
          accelXzero=accelXzero/DAT_SIZE;
          accelYzero=accelYzero/DAT_SIZE;
          gyrozero=gyrozero/DAT_SIZE; 
          mode=1;
          datpos=0;
        }        
      break;
      case 1:        
        accelX[datpos]=accelraw[0];
        accelY[datpos]=accelraw[1];//dat[datpos]=accelraw[1];
        gyroZ[datpos]=gyroraw[2];//dat[datpos-(DAT_SIZE>>1)]=gyroraw[2]; 
        //
        #ifdef INT_VER 
        //average .7276ms with all integer operations except for theta/sin/cos
        //average .3272ms with lookup array trig functions SinFunction() and CosFunction()
        //RestartTimer();for(i=0;i<100;i++){   
        gyropos+=((gyroraw[2]-gyrozero));//GyroRawToDegreesMult
        degr=(((float)gyropos)*(0.0000355*2000/380));
        //Theta=((float)degr)*3.14159/180;//((0.0000355*2000)*3.14159/180/380);//see AccelXYGData tab of Moody1 spreadsheet
        //SinTheta=(int)(sin(Theta)*0x4000);
        //CosTheta=(int)(cos(Theta)*0x4000);
        SinDegr=SinFunction(degr);
        CosDegr=CosFunction(degr);
        accelxvel+=((((int32_t)accelraw[0])-accelXzero)*CosDegr-(((int32_t)accelraw[1])-accelYzero)*SinDegr)/0x4000;//see AccelXYGData tab of Moody1 spreadsheet
        accelyvel+=((((int32_t)accelraw[1])-accelYzero)*CosDegr+(((int32_t)accelraw[0])-accelXzero)*SinDegr)/0x4000;//see AccelXYGData tab of Moody1 spreadsheet
        accelxpos+=(int32_t)accelxvel;            
        accelypos+=(int32_t)accelyvel;  
        //}Serial.println(GetTime(),DEC);
        #endif
        //
        //
        #ifdef FLOAT_VER
        //average: .973ms
        //RestartTimer();for(i=0;i<100;i++){        
        gyropos+=((float)(gyroraw[2]-gyrozero))/380;//GyroRawToDegreesMult
        Theta=gyropos*((0.0000355*2000)*3.14159/180);//see AccelXYGData tab of Moody1 spreadsheet
        SinTheta=sin(Theta);
        CosTheta=cos(Theta);
        accelxvel+=((accelraw[0]-accelXzero)*CosTheta-(accelraw[1]-accelYzero)*SinTheta)/380;//see AccelXYGData tab of Moody1 spreadsheet
        accelyvel+=((accelraw[1]-accelYzero)*CosTheta+(accelraw[0]-accelXzero)*SinTheta)/380;//see AccelXYGData tab of Moody1 spreadsheet
        accelxpos+=accelxvel/380;
        accelypos+=accelyvel/380;
        //}Serial.println(GetTime(),DEC);
        #endif
        //
        datpos++;
        if(datpos==10){
          SwitchMotorsToSerial();Serial.println("motors on");
          SwitchButtonToPixels();
          SetPixelRGB(5,0,50,0);SetPixelRGB(6,0,50,0);RefreshPixels();
          SwitchSerialToMotors();
          Motors(leftmotor,rightmotor);
        }
        //if(datpos==2*DAT_SIZE/4){
        //  SwitchMotorsToSerial();Serial.println("motors twitch");
        //  SwitchButtonToPixels();
        //  SetPixelRGB(5,0,0,0);SetPixelRGB(6,0,0,0);RefreshPixels();
        //  SwitchSerialToMotors();
        //  Motors(250,-250);
        //  SwitchMotorsToSerial();          
        //}
        if(datpos==3*DAT_SIZE/4){
          SwitchMotorsToSerial();Serial.println("motors off");
          SwitchButtonToPixels();
          SetPixelRGB(5,0,0,0);SetPixelRGB(6,0,0,0);RefreshPixels();
          SwitchSerialToMotors();
          Motors(0,0);
          SwitchMotorsToSerial();          
        }
        //if(datpos>=3*DAT_SIZE/4)
        //  Serial.println((gyropos)*(-0.0000355*2000),DEC);//*(-0.0000355*2000)
        if(datpos==DAT_SIZE){
          Serial.print("gyro buf "); Serial.print((int)AccelBufferSize(),DEC);
          Serial.print(" accel buf "); Serial.println((int)GyroBufferSize(),DEC);          
          mode=2;
        }
      break;
      }//end switch(mode)
    }//end if(GyroBufferSize()>0)
      
    if(mode==2){
      SwitchPixelsToButton(); 
      if(ButtonPressed()){
        Serial.println("X,Y,Degrees: ");
        #ifdef INT_VER
        Serial.print((float)accelxpos*(-((float)(2*9800))/32768/380/380),DEC);Serial.print("\t");Serial.print(((float)accelypos)*(-((float)(2*9800))/32768/380/380),DEC);Serial.print("\t");Serial.println(-((float)gyropos)*(0.0000355*2000)/380,DEC);        
        #endif 
        #ifdef FLOAT_VER
        Serial.print((float)accelxpos*(-(float)(2*9800)/32768),DEC);Serial.print("\t");Serial.print((float)accelypos*(-(float)(2*9800)/32768),DEC);Serial.print("\t");Serial.println(-gyropos*(0.0000355*2000),DEC);        
        #endif        
        Serial.println("zeroes: ");
        Serial.print(accelXzero,DEC);
        Serial.print("\t");
        Serial.print(accelYzero,DEC);
        Serial.print("\t");
        Serial.print(gyrozero,DEC);
        Serial.println();
        Serial.println("accelX raw\taccelY raw\tgyro raw");
        for(i=0;i<datpos;i++){
          Serial.print(accelX[i],DEC);
          Serial.print("\t");
          Serial.print(accelY[i],DEC);
          Serial.print("\t");
          Serial.println(gyroZ[i],DEC);
        }
        //
        break;
      }//end if(ButtonPressed())
      SwitchButtonToPixels();   
      if(GetTime()>200){//
        rawaccelsquared=0;
        accelsquared=0;
        for(i=0;i<3;i++){
          accel[i]=accelraw[i]*(-(float)(2*9800)/32768);//range: 2g, g=9.8m/s^2
          rawaccelsquared+=((int32_t)accelraw[i])*((int32_t)accelraw[i]);
          accelsquared+=((int32_t)accel[i])*((int32_t)accel[i]);
          gyro[i]=-((float)gyroraw[i])*2000*0.0000355;
        }  
        //gyro:
        //range	calc dps/dig	"typ" in datasheet	to get to "typ"		
        //250	0.007629395	0.00875           	1.14687993         
        //500	0.015258789	0.0175           	1.146880005
        //2000	0.061035156	0.070            	1.146880005
        // 1/2^15*1.14688=exactly .000035          
        dir=90-atan2(accely,accelx)*180/3.14159;
        SwitchMotorsToSerial();
        Serial.print(accelraw[0],DEC);
        Serial.print(" ");
        Serial.print(accelraw[1],DEC);
        Serial.print(" ");
        Serial.print(accelraw[2],DEC);
        Serial.print(" dir ");
        Serial.println(dir,DEC);
        Serial.print(" ");
        Serial.print(accel[0],DEC);
        Serial.print(" ");
        Serial.print(accel[1],DEC);
        Serial.print(" ");
        Serial.print(accel[2],DEC);
        Serial.println();
        Serial.print(" raw amplitude ");
        Serial.print(sqrt(rawaccelsquared),DEC);
        Serial.print(" amplitude ");    
        Serial.print(sqrt(accelsquared),DEC);
        Serial.print(" gyro raw ");  
        Serial.print(gyroraw[2],DEC);
        Serial.print(" dps ");
        Serial.print(gyro[2],DEC);
        Serial.println();
        RestartTimer(); 
        //          
      }//end if(GetTime()>200)
  }//end if(mode==2)    
    
  }//end while(1)
  
}//end loop()




